/*
    ************************************************
    folderHorizon gallery.js
    * Loaded with project_gallery_wrapper_*.tpl
    ************************************************
*/

// Gallery thumbnail view grid/rows
if (document.getElementById('galleryViewBtn') !== null) {
    document.getElementById('galleryViewBtn').addEventListener('click', function () {
        this.classList.toggle('rows');
        document.getElementById('gallery').classList.toggle('rows');
    });
}

// PhotoSwipe gallery UMD version
const lightbox = new PhotoSwipeLightbox({
    gallery: '#gallery',
    children: 'a',
    bgOpacity: 0.9,
    pswpModule: PhotoSwipe
});

// PhotoSwipe caption
const captionPlugin = new PhotoSwipeDynamicCaption(lightbox, {
    type: 'below',
    mobileLayoutBreakpoint: 700, // 600 > 750
    mobileCaptionOverlapRatio: 1
});

lightbox.init();
