/*
    ************************************************
    folderHorizon sidenavgroups.js
    * Group projects by @ separator
    * Context in sidenav_common.tpl
    * Loaded with section.tpl, project.tpl
    ************************************************
*/

const showSingleItemGroups = true, // Group has single item : show as group or replace the separator?
    context = document.getElementById('sidenavList'),
    list = context.getElementsByTagName('li'),
    titleClass = 'project-group-title',
    projectClass = 'project-group',
    separator = '@',
    replacer = '-';

let groups = [],
    checkSingles = {},
    singleItemGroups = [],
    separatorErrors = []; // Directory name has more than one separator !

// Load groups
for (let i = 0; i < list.length; i++) {
    if (list[i].textContent.includes(separator)) {
        const group = list[i].textContent.split(separator);
        if (group.length !== 2) {
            separatorErrors.push(list[i].textContent)
        } else {
            groups.push(group[0].trim());
        }
    }
}

// Start
if (groups.length > 0) {

    // Get title/element if project page
    let currentProjectTitle = '',
        currentProjectElement = null;

    // Project page title has group !
    if (document.title.includes(separator) && !separatorErrors.includes(document.title)) {
        const count = document.title.split(separator);
        if (count.length === 2) {
            document.title = cleanTitle(document.title);
            const cT = document.getElementsByClassName('content-title');
            if (cT.length !== 0) {
                const pGT = cT[0].textContent.split(separator);
                currentProjectTitle = pGT[0].trim();
                cT[0].textContent = cleanTitle(cT[0].textContent);
            }
        }
    } else if (document.getElementsByClassName('section').length != 0) {
        // Section page figcaption titles check groups !
        const section = document.getElementsByClassName('section')[0];
        const sectionTitles = section.getElementsByTagName('figcaption');
        for (let i = 0; i < sectionTitles.length; i++) {
            sectionTitles[i].textContent = cleanTitle(sectionTitles[i].textContent);
        }
    }

    // You choose...
    if (!showSingleItemGroups) {
        groups.forEach(function (x) { checkSingles[x] = (checkSingles[x] || 0) + 1; });
        for (let n in checkSingles) {
            if (!checkSingles.hasOwnProperty(n)) continue;
            if (checkSingles[n] < 2) singleItemGroups.push(n);
        }
    }

    // Reset and create groups
    groups = [];

    for (let i = 0; i < list.length; i++) {

        const el = list[i],
            text = el.textContent;

        if (separatorErrors.includes(text)) continue;
        if (text.includes(separator)) {
            const group = text.split(separator),
                title = group[0].trim(),
                project = group[1].trim();

            if (singleItemGroups.includes(title)) {
                el.firstElementChild.textContent = cleanTitle(el.firstElementChild.textContent); // <a> !
            } else if (!groups.includes(title)) {
                const groupTitle = document.createElement('li');
                groupTitle.className = titleClass;
                groupTitle.dataset.class = projectClass;

                // Is current project page group ?
                if (title === currentProjectTitle) {
                    currentProjectElement = groupTitle;
                    groupTitle.classList.add('selected');
                }

                groupTitle.dataset.group = title;
                groupTitle.textContent = title;
                groupTitle.addEventListener('click', function () {
                    openProjectGroup(this);
                });

                context.insertBefore(groupTitle, el);
                groups.push(title);

            } else if (groups.includes(title)) {
                el.dataset.group = title;
                el.classList.add(projectClass);
                el.classList.add('hide');
                el.firstElementChild.textContent = project; // <a> !
            }
        }
    }

    // Project page open !
    if (currentProjectElement !== null) openProjectGroup(currentProjectElement);

    function openProjectGroup(p) {
        p.classList.toggle('open');
        const g = context.getElementsByClassName(p.dataset.class);
        for (let i = 0; i < g.length; i++) {
            if (g[i].dataset.group === p.dataset.group) g[i].classList.toggle('hide');
        }
    }

    function cleanTitle(str) {
        return str.replace(separator, replacer);
    }
}
