/*
    ************************************************
    folderHorizon datasource.js
    * Loaded with project.tpl
    ************************************************
*/

// If "EnableEmbedSourcePath": true,
// right clicking on the figure,
// it copies the archive filepath to the clipboard.
const clipboard = navigator.clipboard;
if (clipboard !== undefined) {
    const dataSource = document.querySelectorAll('[data-source]');
    if (dataSource.length > 0) {
        for (let i = 0; i < dataSource.length; i++) {
            const fig = dataSource[i];
            if (fig.dataset.source !== '') {
                fig.addEventListener('contextmenu', function () {
                    navigator.clipboard.writeText(this.dataset.source);
                    this.style.borderTop = '4px dotted orangered';
                    setTimeout(function () {
                        fig.removeAttribute('style');
                    }, 300);
                }, false);
            }
        }
    }
} else {
    console.log('EnableEmbedSourcePath requires HTTPS.');
}
