/*
    ************************************************
    folderHorizon main.js
    - Mobile menu buttons
    - Detect vertical video
    * Loaded with global_footer.tpl
    ************************************************
*/

// Mobile menu buttons
const sidenavBtn = document.getElementById('sidenavBtn'),
    sidenavBar = document.getElementById('sidenavBar'),
    selected = topnavBar.getElementsByClassName('selected'),
    sidenavBtnVerticalOffet = 5;

document.getElementById('topnavBtn').addEventListener('click', function () {
    this.classList.toggle('open');
    const topnavBar = document.getElementById('topnavBar');
    topnavBar.classList.toggle('show');
    sidenavBtn.removeAttribute('style');
    if (this.classList.contains('open') && selected.length === 1) {
        setTimeout(function () {
            sidenavBtn.style.top = (selected[0].offsetTop + sidenavBtnVerticalOffet) + 'px';
        }, 500);
    }
    if (sidenavBtn.classList.contains('open')) sidenavBar.classList.remove('show');
});

sidenavBtn.addEventListener('click', function () {
    this.classList.toggle('open');
    sidenavBar.classList.toggle('show');
});

// Detect vertical video
const video = document.getElementsByTagName('video');

if (video.length > 0) {
    for (let i = 0; i < video.length; i++) {
        if (
            video[i].offsetHeight > video[i].offsetWidth &&
            video[i].offsetHeight > window.innerHeight
        ) video[i].classList.add('vertical-video');
    }
}
