/*
    ************************************************
    folderHorizon/joinReleases search.js > fuse.js
    * Loaded with search.tpl
    ************************************************
*/

const target = 'frame', // _blank | frame (joinReleases)
    searchSkipWords = [], // List of words to skip in search (case insensitive)
    searchInput = document.getElementById('searchInput'),
    searchButton = document.getElementById('searchButton'),
    searchMessage = document.getElementById('searchMessage'),
    searchResult = document.getElementById('searchResult'),
    // Fuse options
    options = {
        includeMatches: true,
        findAllMatches: true,
        minMatchCharLength: 3,
        threshold: 0.1, // Default 0.6 :: 0.0 requires a perfect match, 1.0 would match anything
        useExtendedSearch: true,
        ignoreLocation: true,
        keys: ['text', 'tags', 'captions']
    },
    UL = '<ul>',
    ULend = '</ul><br>',
    LI = '<li>',
    LInodot = '<li class="nodot">',
    LIend = '</li>';

searchInput.addEventListener('keypress', function (event) {
    if (event.key === 'Enter') {
        event.preventDefault();
        searchButton.click();
    }
});

searchButton.addEventListener('click', function () {
    searchMessage.textContent = '';
    searchResult.textContent = '';

    if (searchInput.value.length < options.minMatchCharLength) {
        searchMessage.textContent = ' ...min ' + options.minMatchCharLength + ' chars!'
        return
    }

    if (searchSkipWords.length > 0 && skipWord(searchInput.value)) {
        searchMessage.textContent = ' ...too many results';
        return
    }

    const fuse = new Fuse(searchdata, options),
        result = fuse.search(searchInput.value);

    if (result.length < 1) {
        searchMessage.textContent = ' ...not found';
    } else {
        let more = '';
        if (result.length > 1) more = 's';
        searchMessage.textContent = ' ...found in ' + result.length + ' page' + more;
        printResult(result);
    }
});

function skipWord(input) {
    for (let i = 0; i < searchSkipWords.length; i++) {
        let r = new RegExp('^' + searchSkipWords[i] + '$', 'i');
        if (r.test(input.trim())) return true
    }
    return false
}

function printResult(res) {
    for (let i = 0; i < res.length; i++) {

        const div = document.createElement('div'),
            keys = res[i].matches,
            name = (res[i].item.name === undefined) ? '' : res[i].item.name,
            context = (res[i].item.context === '') ? 'Homepage' : res[i].item.context;

        let text = [],
            tags = [],
            captions = [];

        // Result header
        div.innerHTML += '<p><span>' + name + '</span><a href="' + res[i].item.href + '" target="' + target + '">' + context + '</a></p>';

        // Load matches
        for (let k = 0; k < keys.length; k++) {
            if (keys[k].key === 'text') text.push(keys[k].value);
            if (keys[k].key === 'tags') tags.push(keys[k].value);
            if (keys[k].key === 'captions') captions.push(keys[k].value);
        }

        // page text matches
        if (text.length > 0) {
            div.innerHTML += UL + 'page text';
            for (let p = 0; p < text.length; p++) {
                div.innerHTML += LInodot + '[... ' + text[p] + ' ...]' + LIend;
            }
            div.innerHTML += ULend;
        }

        // page tags matches
        if (tags.length > 0) {
            div.innerHTML += '<b>tags</b>';
            for (let t = 0; t < tags.length; t++) {
                div.innerHTML += ' #' + tags[t] + LIend;
            }
            div.innerHTML += '<br><br>';
        }

        // file captions matches
        if (captions.length > 0) {
            div.innerHTML += UL + 'file captions';
            for (let c = 0; c < captions.length; c++) {
                div.innerHTML += LI + captions[c] + LIend;
            }
            div.innerHTML += ULend;
        }

        // Print
        div.classList.add('search-result');
        searchResult.appendChild(div);
    }
}